// External oscillator frequency
#define SYSCLK          16000000
#include "p24fj128ga008.h"
//#include "LCD24F.h"

// Setup configuration bits
_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )


	// LCD Module I/O pins
	#define LCD_DATA_TRIS	    (unsigned char)TRISE //(*((volatile BYTE*)&TRISE))
	#define LCD_DATA_IO		    (unsigned char)LATE  //(*((volatile BYTE*)&LATE))
	#define LCD_RD_WR_TRIS		(TRISEbits.TRISE5)
	#define LCD_RD_WR_IO		(LATEbits.LATE5)
	#define LCD_RS_TRIS			(TRISEbits.TRISE4)
	#define LCD_RS_IO			(LATEbits.LATE4)
	#define LCD_E_TRIS			(TRISEbits.TRISE6)
	#define LCD_E_IO			(LATEbits.LATE6)


void delay(void)
{
   long int n;
   for (n=0;n<200000;n++); 
}

void Short_delay(void)
{
   long int n;
   for (n=0;n<1000;n++); 
}

/******************************************************************************
 * Function:        static void LCDWrite_CMD(BYTE Data)
 *
 * PreCondition:    None
 *
 * Input:           RS = 0 Write to Config registers
 *					Data - 8 bits of data to write
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Controls the Port I/O pins to cause an LCD write
 *
 * Note:            None
 *****************************************************************************/
static void LCDWrite_CMD(unsigned char Data)
{
   
    LCD_E_IO = 1;
    LCD_RS_IO = 0;
    LCD_RD_WR_IO =0;
   
    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= ((Data>>4) & 0x0F);
   
	Nop();
	Nop();				
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= (Data & 0x0F);

	Nop();					// Wait Data setup time (min 40ns)
	Nop();
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

}


/******************************************************************************
 * Function:        static void LCDWrite_DAT(BYTE Data)
 *
 * PreCondition:    None
 *
 * Input:           RS =1  Register Select to DDRRAM
 *					Data - 8 bits of data to write
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Controls the Port I/O pins to cause an LCD write
 *
 * Note:            None
 *****************************************************************************/
static void LCDWrite_DAT(unsigned char Data)
{
    LCD_RS_IO = 1;
    LCD_E_IO = 1;
    LCD_RD_WR_IO =0;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= ((Data>>4) & 0x0F);
   
	Nop();
	Nop();				
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;

    LCD_DATA_IO &= 0xF0;
	LCD_DATA_IO |= (Data & 0x0F);

	Nop();					// Wait Data setup time (min 40ns)
	Nop();
	LCD_E_IO = 0;
	Nop();             	   // Wait E Pulse width time
	Nop();
	Nop();Short_delay();
    LCD_E_IO = 1;
}



/******************************************************************************
 * Function:        void LCDInit(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        LCDText[] is blanked, port I/O pin TRIS registers are 
 *					configured, and the LCD is placed in the default state
 *
 * Note:            None
 *****************************************************************************/
void LCDInit(void)
{
    delay();
    delay();
    delay();   // wait for LCD Start-up

    LCDWrite_CMD(0x33);
    LCDWrite_CMD(0x32);
    LCDWrite_CMD(0x28);
    LCDWrite_CMD(0x0C);
    LCDWrite_CMD(0x06);
    LCDWrite_CMD(0x01);
    LCDWrite_CMD(0x01);

}

//************************************************************
//                  main program here                        *
//************************************************************

int main ()
{   
   int k;
   
   unsigned char text1[]="ET-PIC24WEB-V1 ";
   unsigned char text2[]=" www.ett.co.th ";

	//Code goes here                                   								

	AD1PCFG = 0xFFFF;
    TRISD = 0x0000;

	LCD_E_IO = 1;
	LCD_RD_WR_IO = 0;

	LCD_DATA_TRIS = 0x00;
	LCD_RD_WR_TRIS = 0;
	LCD_RS_TRIS = 0;
 
    LCDInit();


   for (k=0;k<sizeof(text1)-1;k++)   // Print Text to line 1 LCD
	{
      LCDWrite_DAT(text1[k]); 
	}

    LCDWrite_CMD(0xC0);    //  goto line 2 LCD

    for (k=0;k<sizeof(text2)-1;k++)  // Print Text to line 2 LCD  
	{
      LCDWrite_DAT(text2[k]); 
	}

    while (1);
}
